function [a]=sens_plot3(skt,n,fbw);
  if (nargin==1)
    n=1000;
    fbw=0.01;
  end
  pkg load signal;
  ntaps=2/fbw;
  ntaps=(floor(ntaps/2)*2)+1;
  bb=fir1(ntaps-1,fbw);
  n=n+ntaps-1;
  ntby2=floor(ntaps/2);
  
  
sinlength=10000.0/32768.0;
pos=[];
a=zeros(1,n);
[a,ptr]=GetSensData(skt,a,1);
a=zeros(1,n);
[a,ptr]=GetSensData(skt,a,ptr);
%measure is signed - so convert from unsigned to signed
pos=a;
idx=find(pos>32767.0);
pos(idx)=pos(idx)-65536;
pos=pos*sinlength;
fpos=filter(bb,1,pos)(ntaps:end);
pos=pos((ntby2+1):(end-ntby2));
ppos=[ pos' fpos'];
figure(1)
phdl=plot(ppos);
s=sprintf('mean pos= %2.4fum  rms=%2.4fum',mean(pos),sqrt(var(pos)));
s=[s sprintf('mean pos= %2.4fum  rms=%2.4fum',mean(pos),sqrt(var(pos)))];
ylabel('um');
thdl=title(s);
grid on;


while (size(kbhit(1))(1)<1) 
  [a,ptr]=GetSensData(skt,a,ptr);
  pos=a;
  idx=find(pos>32767.0);
  pos(idx)=pos(idx)-65536;
  pos=pos*sinlength;
  
  fpos=filter(bb,1,pos)(ntaps:end);
  pos=pos((ntby2+1):(end-ntby2));
  s=sprintf('un-filtered mean pos= %2.4fum  rms=%2.4fum',mean(pos),sqrt(var(pos)));
  s=[s sprintf('       filtered mean pos= %2.4fum  rms=%2.4fum',mean(fpos),sqrt(var(fpos)))];
  set(thdl,'string',s);
  set(phdl(1),'ydata',pos');
  set(phdl(2),'ydata',fpos');
  drawnow;
  end
end
  